function w = passeggiata_unod_chemotaxisdiffusion(v,c,theta,chi,cmax)
%Funzione che prende in input un vettore colonna a valori interi positivi 
%di lunghezza almeno 3, un vettore di concentrazione chimica della stessa 
%dimensione, la probabilità massima di moto e il valore che normalizza la 
%concentrazione e restituisce il vettore ottenuto compiendo un passo di 
%un passegiata secondo chemotassi


%NB: per usare mnrnd è fondamentale che i vettori siano colonne
prob_s=theta/2+chi*subplus(c(1:end-2)-c(2:end-1))/(2*cmax);
prob_d=theta/2+chi*subplus(c(3:end)-c(2:end-1))/(2*cmax);

b=mnrnd(v(2:end-1),[prob_s 1-prob_s-prob_d prob_d]);

w=[b(:,1);0;0]+[0;b(:,2);0]+[0;0;b(:,3)];

%estremi
a=binornd(v(1),theta/2+chi*subplus(c(2)-c(1))/(2*cmax));
w(1)=w(1)+v(1)-a;
w(2)=w(2)+a;

a=binornd(v(end),theta/2+chi*subplus(c(end-1)-c(end))/(2*cmax));
w(end)=w(end)+v(end)-a;
w(end-1)=w(end-1)+a;
